/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr.appletssl;

import com.ibm.hwmca.fw.connmgr.appletssl.DHParms;
import com.ibm.hwmca.fw.connmgr.appletssl.MD5;
import com.ibm.hwmca.fw.connmgr.appletssl.RC4;
import com.ibm.hwmca.fw.connmgr.appletssl.SHA1;
import com.ibm.hwmca.fw.connmgr.appletssl.SSLConstants;
import com.ibm.hwmca.fw.connmgr.appletssl.SSLInputStream;
import com.ibm.hwmca.fw.connmgr.appletssl.SSLOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.util.Random;

public class SSLConnection
implements SSLConstants {
    private boolean isExportable;
    private int compressionAlgorithm;
    private int cipherSpec;
    private long clientSeqNum;
    private long serverSeqNum;
    private byte[] sessionId;
    private byte[] preMasterSecret;
    private byte[] masterSecret = new byte[48];
    private byte[] clientRandom = new byte[32];
    private byte[] serverRandom = new byte[32];
    private byte[] clientWriteMACSecret = new byte[16];
    private byte[] serverWriteMACSecret = new byte[16];
    private byte[] clientWriteKey = new byte[16];
    private byte[] serverWriteKey = new byte[16];
    private BigInteger serverKeyExchangeModulus;
    private BigInteger serverKeyExchangeExponent;
    private boolean serverKeyExchangeReceived = false;
    private boolean serverHelloDoneReceived = false;
    private boolean serverFinishedReceived = false;
    private boolean serverCertRequestReceived = false;
    private ByteArrayOutputStream savedHandshakes = new ByteArrayOutputStream(1024);
    private MD5 md5 = new MD5();
    private SHA1 sha1 = new SHA1();
    RC4 clientRC4 = null;
    RC4 serverRC4 = null;
    private DHParms dhParms;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private BufferedOutputStream bufOut;
    private final SSLRecord inputRecord = new SSLRecord();
    private static final byte[] SENDER_CLIENT;
    private static final byte[] SENDER_SERVER;
    private static final byte[] PAD1_MD5;
    private static final byte[] PAD2_MD5;
    private static final byte[] PAD1_SHA;
    private static final byte[] PAD2_SHA;
    private static boolean debug;
    private final byte[] handshakeBlock = new byte[16384];
    private final byte[] alertBlock = new byte[2];
    private static final byte[] changeCipherSpecBlock;
    private final byte[] writeBlock = new byte[18432];
    private Object writeLock = new Object();
    private Object readLock = new Object();
    private int bytesRemaining = 0;
    private int currOffset = 0;
    private final byte[] oneReadByte = new byte[1];

    public SSLConnection(String host, int port) throws IOException {
        this.socket = new Socket(host, port);
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.bufOut = new BufferedOutputStream(this.socket.getOutputStream());
        this.out = new DataOutputStream(this.bufOut);
        this.doHandshake();
    }

    private void doHandshake() throws IOException {
        SSLConnection.debugPrint("Sending client hello");
        this.writeClientHello();
        while (!this.serverHelloDoneReceived) {
            this.readServerResponse();
        }
        if (this.serverCertRequestReceived) {
            this.writeClientCertificate();
        }
        this.writeClientKeyExchange();
        this.writeChangeCipherSpec();
        this.computeSecrets();
        this.clientRC4 = new RC4();
        this.clientRC4.init(this.clientWriteKey);
        this.writeFinished();
        while (!this.serverFinishedReceived) {
            this.readServerResponse();
        }
    }

    private void writeClientHello() throws IOException {
        byte[] clientHello = new byte[]{3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 24, 0, 23, 1, 0};
        new Random().nextBytes(this.clientRandom);
        int time = (int)(System.currentTimeMillis() / 1000L);
        this.clientRandom[0] = (byte)(time >> 24 & 0xFF);
        this.clientRandom[1] = (byte)(time >> 16 & 0xFF);
        this.clientRandom[2] = (byte)(time >> 8 & 0xFF);
        this.clientRandom[3] = (byte)(time & 0xFF);
        System.arraycopy(this.clientRandom, 0, clientHello, 2, this.clientRandom.length);
        this.writeHandshake((byte)1, clientHello);
    }

    private void writeClientKeyExchange() throws IOException {
        byte[] Yc = this.dhParms.getOurPublicValue().toByteArray();
        SSLConnection.debugPrint("first byte of our public value: " + Integer.toHexString(Yc[0] & 0xFF));
        byte[] keyExchange = new byte[Yc.length + 2];
        keyExchange[0] = (byte)(Yc.length >> 8);
        keyExchange[1] = (byte)Yc.length;
        System.arraycopy(Yc, 0, keyExchange, 2, Yc.length);
        this.writeHandshake((byte)16, keyExchange);
        SSLConnection.debugPrint("Sent DH client key exchange");
    }

    private void writeClientCertificate() throws IOException {
        this.writeAlert((byte)2, (byte)41);
    }

    private void computeSecrets() {
        this.sha1.init();
        this.md5.init();
        byte[] sha1sum = new byte[20];
        byte[] md5sum = new byte[16];
        this.sha1.init();
        this.sha1.update((byte)65);
        this.sha1.update(this.preMasterSecret, 0, this.preMasterSecret.length);
        this.sha1.update(this.clientRandom, 0, this.clientRandom.length);
        this.sha1.update(this.serverRandom, 0, this.serverRandom.length);
        this.sha1.dump(sha1sum, 0);
        this.md5.init();
        this.md5.update(this.preMasterSecret, 0, this.preMasterSecret.length);
        this.md5.update(sha1sum, 0, sha1sum.length);
        this.md5.dump(this.masterSecret, 0);
        this.sha1.init();
        this.sha1.update((byte)66);
        this.sha1.update((byte)66);
        this.sha1.update(this.preMasterSecret, 0, this.preMasterSecret.length);
        this.sha1.update(this.clientRandom, 0, this.clientRandom.length);
        this.sha1.update(this.serverRandom, 0, this.serverRandom.length);
        this.sha1.dump(sha1sum, 0);
        this.md5.init();
        this.md5.update(this.preMasterSecret, 0, this.preMasterSecret.length);
        this.md5.update(sha1sum, 0, sha1sum.length);
        this.md5.dump(this.masterSecret, 16);
        this.sha1.init();
        this.sha1.update((byte)67);
        this.sha1.update((byte)67);
        this.sha1.update((byte)67);
        this.sha1.update(this.preMasterSecret, 0, this.preMasterSecret.length);
        this.sha1.update(this.clientRandom, 0, this.clientRandom.length);
        this.sha1.update(this.serverRandom, 0, this.serverRandom.length);
        this.sha1.dump(sha1sum, 0);
        this.md5.init();
        this.md5.update(this.preMasterSecret, 0, this.preMasterSecret.length);
        this.md5.update(sha1sum, 0, sha1sum.length);
        this.md5.dump(this.masterSecret, 32);
        for (int i = 0; i < this.preMasterSecret.length; ++i) {
            this.preMasterSecret[i] = 0;
        }
        this.sha1.init();
        this.sha1.update((byte)65);
        this.sha1.update(this.masterSecret, 0, this.masterSecret.length);
        this.sha1.update(this.serverRandom, 0, this.serverRandom.length);
        this.sha1.update(this.clientRandom, 0, this.clientRandom.length);
        this.sha1.dump(sha1sum, 0);
        this.md5.init();
        this.md5.update(this.masterSecret, 0, this.masterSecret.length);
        this.md5.update(sha1sum, 0, sha1sum.length);
        this.md5.dump(this.clientWriteMACSecret, 0);
        this.sha1.init();
        this.sha1.update((byte)66);
        this.sha1.update((byte)66);
        this.sha1.update(this.masterSecret, 0, this.masterSecret.length);
        this.sha1.update(this.serverRandom, 0, this.serverRandom.length);
        this.sha1.update(this.clientRandom, 0, this.clientRandom.length);
        this.sha1.dump(sha1sum, 0);
        this.md5.init();
        this.md5.update(this.masterSecret, 0, this.masterSecret.length);
        this.md5.update(sha1sum, 0, sha1sum.length);
        this.md5.dump(this.serverWriteMACSecret, 0);
        byte[] keyBlock = new byte[32];
        this.sha1.init();
        this.sha1.update((byte)67);
        this.sha1.update((byte)67);
        this.sha1.update((byte)67);
        this.sha1.update(this.masterSecret, 0, this.masterSecret.length);
        this.sha1.update(this.serverRandom, 0, this.serverRandom.length);
        this.sha1.update(this.clientRandom, 0, this.clientRandom.length);
        this.sha1.dump(sha1sum, 0);
        this.md5.init();
        this.md5.update(this.masterSecret, 0, this.masterSecret.length);
        this.md5.update(sha1sum, 0, sha1sum.length);
        this.md5.dump(keyBlock, 0);
        this.sha1.init();
        this.sha1.update((byte)68);
        this.sha1.update((byte)68);
        this.sha1.update((byte)68);
        this.sha1.update((byte)68);
        this.sha1.update(this.masterSecret, 0, this.masterSecret.length);
        this.sha1.update(this.serverRandom, 0, this.serverRandom.length);
        this.sha1.update(this.clientRandom, 0, this.clientRandom.length);
        this.sha1.dump(sha1sum, 0);
        this.md5.init();
        this.md5.update(this.masterSecret, 0, this.masterSecret.length);
        this.md5.update(sha1sum, 0, sha1sum.length);
        this.md5.dump(keyBlock, 16);
        switch (this.cipherSpec) {
            case 23: {
                byte[] preKey = new byte[5];
                System.arraycopy(keyBlock, 0, preKey, 0, 5);
                this.md5.init();
                this.md5.update(preKey, 0, 5);
                this.md5.update(this.clientRandom, 0, this.clientRandom.length);
                this.md5.update(this.serverRandom, 0, this.serverRandom.length);
                this.md5.dump(this.clientWriteKey, 0);
                System.arraycopy(keyBlock, 5, preKey, 0, 5);
                this.md5.init();
                this.md5.update(preKey, 0, 5);
                this.md5.update(this.serverRandom, 0, this.serverRandom.length);
                this.md5.update(this.clientRandom, 0, this.clientRandom.length);
                this.md5.dump(this.serverWriteKey, 0);
                break;
            }
            case 24: {
                System.arraycopy(keyBlock, 0, this.clientWriteKey, 0, 16);
                System.arraycopy(keyBlock, 16, this.serverWriteKey, 0, 16);
            }
        }
    }

    private void writeFinished() throws IOException {
        byte[] finished = new byte[36];
        byte[] handshakes = this.savedHandshakes.toByteArray();
        byte[] md5sum = new byte[16];
        byte[] sha1sum = new byte[20];
        this.md5.init();
        this.md5.update(handshakes, 0, handshakes.length);
        this.md5.update(SENDER_CLIENT, 0, SENDER_CLIENT.length);
        this.md5.update(this.masterSecret, 0, this.masterSecret.length);
        this.md5.update(PAD1_MD5, 0, PAD1_MD5.length);
        this.md5.dump(md5sum, 0);
        this.md5.init();
        this.md5.update(this.masterSecret, 0, this.masterSecret.length);
        this.md5.update(PAD2_MD5, 0, PAD2_MD5.length);
        this.md5.update(md5sum, 0, md5sum.length);
        this.md5.dump(finished, 0);
        this.sha1.init();
        this.sha1.update(handshakes, 0, handshakes.length);
        this.sha1.update(SENDER_CLIENT, 0, SENDER_CLIENT.length);
        this.sha1.update(this.masterSecret, 0, this.masterSecret.length);
        this.sha1.update(PAD1_SHA, 0, PAD1_SHA.length);
        this.sha1.dump(sha1sum, 0);
        this.sha1.init();
        this.sha1.update(this.masterSecret, 0, this.masterSecret.length);
        this.sha1.update(PAD2_SHA, 0, PAD2_SHA.length);
        this.sha1.update(sha1sum, 0, sha1sum.length);
        this.sha1.dump(finished, 16);
        this.writeHandshake((byte)20, finished);
        SSLConnection.debugPrint("Sent finished message");
    }

    private void writeHandshake(byte type, byte[] data) throws IOException {
        this.handshakeBlock[0] = type;
        this.handshakeBlock[1] = (byte)(data.length >> 16 & 0xFF);
        this.handshakeBlock[2] = (byte)(data.length >> 8 & 0xFF);
        this.handshakeBlock[3] = (byte)(data.length & 0xFF);
        System.arraycopy(data, 0, this.handshakeBlock, 4, data.length);
        this.write(this.handshakeBlock, 0, data.length + 4, (byte)22);
        this.savedHandshakes.write(this.handshakeBlock, 0, data.length + 4);
    }

    private void writeAlert(byte level, byte description) throws IOException {
        this.alertBlock[0] = level;
        this.alertBlock[1] = description;
        this.write(this.alertBlock, 0, this.alertBlock.length, (byte)21);
    }

    private void writeChangeCipherSpec() throws IOException {
        this.write(changeCipherSpecBlock, 0, 1, (byte)20);
        SSLConnection.debugPrint("Sent Change Cipher Spec message");
        this.clientSeqNum = 0L;
    }

    private void write(byte[] data, int offset, int len, byte type) throws IOException {
        if (len > 16384) {
            this.write(data, offset, 16384, type);
            this.write(data, offset + 16384, len - 16384, type);
        } else if (this.clientRC4 == null) {
            this.out.writeByte(type);
            this.out.writeByte(3);
            this.out.writeByte(0);
            this.out.writeShort(len);
            this.out.write(data, offset, len);
            this.bufOut.flush();
        } else {
            int encryptedLen = len + 16;
            byte[] mac = new byte[16];
            MD5 m = new MD5();
            m.init();
            m.update(this.clientWriteMACSecret, 0, this.clientWriteMACSecret.length);
            m.update(PAD1_MD5, 0, PAD1_MD5.length);
            for (int i = 56; i >= 0; i -= 8) {
                m.update((byte)(this.clientSeqNum >> i));
            }
            m.update(type);
            m.update((byte)(len >> 8));
            m.update((byte)len);
            m.update(data, offset, len);
            m.dump(mac, 0);
            m.init();
            m.update(this.clientWriteMACSecret, 0, this.clientWriteMACSecret.length);
            m.update(PAD2_MD5, 0, PAD2_MD5.length);
            m.update(mac, 0, 16);
            m.dump(mac, 0);
            this.clientRC4.processBytes(data, offset, len, this.writeBlock, 0);
            this.clientRC4.processBytes(mac, 0, mac.length, this.writeBlock, len);
            this.out.writeByte(type);
            this.out.writeByte(3);
            this.out.writeByte(0);
            this.out.writeShort(encryptedLen);
            this.out.write(this.writeBlock, 0, encryptedLen);
            this.bufOut.flush();
        }
        ++this.clientSeqNum;
    }

    private void readServerResponse() throws IOException {
        this.readRecord(this.inputRecord);
        switch (this.inputRecord.type) {
            case 20: {
                SSLConnection.debugPrint("received: Change Cipher Spec");
                if (this.serverRC4 != null) {
                    this.writeAlert((byte)2, (byte)10);
                    this.closeConnection();
                    throw new IOException("Received unexpected ChangeCipherSpec message.");
                }
                this.serverRC4 = new RC4();
                this.serverRC4.init(this.serverWriteKey);
                this.serverSeqNum = 0L;
                break;
            }
            case 21: {
                SSLConnection.debugPrint("received: Alert");
                this.processAlerts(this.inputRecord);
                break;
            }
            case 22: {
                SSLConnection.debugPrint("received: Handshake");
                this.processHandshakes(this.inputRecord);
                break;
            }
            case 23: {
                SSLConnection.debugPrint("received: Application Data");
                this.processApplicationData(this.inputRecord);
                break;
            }
        }
    }

    private void readRecord(SSLRecord record) throws IOException {
        record.type = this.in.readByte();
        record.majorVersion = this.in.readByte();
        record.minorVersion = this.in.readByte();
        record.length = this.in.readShort();
        byte[] buf = new byte[record.length];
        this.in.readFully(buf);
        if (this.serverRC4 != null) {
            int i;
            int contentLen = buf.length - 16;
            record.length = (short)contentLen;
            if (record.content == null || record.content.length < contentLen) {
                record.content = new byte[contentLen];
            }
            byte[] unencryptedMAC = new byte[16];
            byte[] mac = new byte[16];
            this.serverRC4.processBytes(buf, 0, contentLen, record.content, 0);
            this.serverRC4.processBytes(buf, contentLen, 16, unencryptedMAC, 0);
            MD5 m = new MD5();
            m.init();
            m.update(this.serverWriteMACSecret, 0, this.serverWriteMACSecret.length);
            m.update(PAD1_MD5, 0, PAD1_MD5.length);
            for (i = 56; i >= 0; i -= 8) {
                m.update((byte)(this.serverSeqNum >> i));
            }
            m.update(record.type);
            m.update((byte)(contentLen >> 8));
            m.update((byte)contentLen);
            m.update(record.content, 0, contentLen);
            m.dump(mac, 0);
            m.init();
            m.update(this.serverWriteMACSecret, 0, this.serverWriteMACSecret.length);
            m.update(PAD2_MD5, 0, PAD2_MD5.length);
            m.update(mac, 0, mac.length);
            m.dump(mac, 0);
            for (i = 0; i < mac.length; ++i) {
                if (mac[i] == unencryptedMAC[i]) continue;
                this.writeAlert((byte)2, (byte)20);
                this.closeConnection();
                throw new IOException("MAC mismatch");
            }
            ++this.serverSeqNum;
        } else if (record.content == null || record.content.length < record.length) {
            record.content = buf;
        } else {
            System.arraycopy(buf, 0, record.content, 0, record.length);
        }
    }

    private void processAlerts(SSLRecord record) throws IOException {
        block9: for (int idx = 0; idx < record.length; idx += 2) {
            byte level = record.content[idx];
            byte desc = record.content[idx + 1];
            switch (desc) {
                case 0: {
                    SSLConnection.debugPrint("ALERT: Received Close Notify message.");
                    this.closeConnection();
                    continue block9;
                }
                case 10: {
                    this.closeConnection();
                    throw new IOException("ALERT: Unexpected message");
                }
                case 20: {
                    this.closeConnection();
                    throw new IOException("ALERT: Bad record mac.");
                }
                case 30: {
                    this.closeConnection();
                    throw new IOException("ALERT: Decompression failure.");
                }
                case 40: {
                    this.closeConnection();
                    throw new IOException("ALERT: Handshake failure.");
                }
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    if (level == 2) {
                        this.closeConnection();
                        throw new IOException("Fatal: Certificate error.");
                    }
                    SSLConnection.debugPrint("Received Warning Alert: Certificate problem [" + desc + "].");
                    continue block9;
                }
                case 47: {
                    this.closeConnection();
                    throw new IOException("Illegal Parameter.");
                }
                default: {
                    SSLConnection.debugPrint("Unknown Alert");
                    throw new IOException("Unknown Alert");
                }
            }
        }
    }

    private void processHandshakes(SSLRecord handshake) throws IOException {
        int idx = 0;
        while (idx < handshake.length) {
            byte type = handshake.content[idx];
            int len = (handshake.content[idx + 1] & 0xFF) << 16 | (handshake.content[idx + 2] & 0xFF) << 8 | handshake.content[idx + 3] & 0xFF;
            SSLConnection.debugPrint("processHandshake(): len=" + len);
            if (type != 0 && type != 20) {
                this.savedHandshakes.write(handshake.content, idx, len + 4);
            }
            switch (type) {
                case 0: {
                    SSLConnection.debugPrint("processHandshake():  HelloRequest");
                    break;
                }
                case 2: {
                    SSLConnection.debugPrint("processHandshake():  ServerHello");
                    byte versionMajor = handshake.content[idx + 4];
                    byte versionMinor = handshake.content[idx + 5];
                    System.arraycopy(handshake.content, idx + 6, this.serverRandom, 0, 32);
                    byte sessionIdLen = handshake.content[idx + 38];
                    this.sessionId = new byte[sessionIdLen];
                    System.arraycopy(handshake.content, idx + 38, this.sessionId, 0, sessionIdLen);
                    this.cipherSpec = (handshake.content[idx += 39 + sessionIdLen] & 0xFF) << 8 | handshake.content[idx + 1] & 0xFF;
                    switch (this.cipherSpec) {
                        case 23: {
                            this.isExportable = true;
                            break;
                        }
                        default: {
                            this.isExportable = false;
                        }
                    }
                    this.compressionAlgorithm = handshake.content[idx + 2] & 0xFF;
                    idx += 3;
                    SSLConnection.debugPrint("version=[" + versionMajor + "," + versionMinor + "]; cipherSpec=[" + this.cipherSpec + "]; compressionAlgorithm=[" + this.compressionAlgorithm + "].");
                    break;
                }
                case 11: {
                    SSLConnection.debugPrint("processHandshake():  Certificate");
                    idx += 4;
                    throw new IOException("Server sent a certificate");
                }
                case 12: {
                    SSLConnection.debugPrint("processHandshake():  ServerKeyExchange");
                    SSLConnection.debugPrint("reading the diffie-hellman parameters");
                    int pLen = (handshake.content[idx += 4] & 0xFF) << 8 | handshake.content[idx + 1] & 0xFF;
                    byte[] p = new byte[pLen];
                    System.arraycopy(handshake.content, idx += 2, p, 0, p.length);
                    BigInteger dh_p = new BigInteger(1, p);
                    SSLConnection.debugPrint("dh_p=" + dh_p);
                    int gLen = (handshake.content[idx += pLen] & 0xFF) << 8 | handshake.content[idx + 1] & 0xFF;
                    byte[] g = new byte[gLen];
                    System.arraycopy(handshake.content, idx += 2, g, 0, g.length);
                    BigInteger dh_g = new BigInteger(1, g);
                    SSLConnection.debugPrint("dh_g=" + dh_g);
                    int YsLen = (handshake.content[idx += gLen] & 0xFF) << 8 | handshake.content[idx + 1] & 0xFF;
                    byte[] Ys = new byte[YsLen];
                    System.arraycopy(handshake.content, idx += 2, Ys, 0, Ys.length);
                    BigInteger dh_Ys = new BigInteger(1, Ys);
                    idx += YsLen;
                    SSLConnection.debugPrint("dh_Ys=" + dh_Ys);
                    this.dhParms = new DHParms(dh_p, dh_g, dh_Ys);
                    byte[] key = this.dhParms.getSecretKey().toByteArray();
                    SSLConnection.debugPrint("First byte of key: " + Integer.toHexString(key[0] & 0xFF));
                    if (key[0] == 0) {
                        this.preMasterSecret = new byte[key.length - 1];
                        System.arraycopy(key, 1, this.preMasterSecret, 0, this.preMasterSecret.length);
                    } else {
                        this.preMasterSecret = key;
                    }
                    SSLConnection.debugPrint("First byte of preMasterSecret: " + Integer.toHexString(this.preMasterSecret[0] & 0xFF));
                    break;
                }
                case 13: {
                    SSLConnection.debugPrint("processHandshake():  CertificateRequest");
                    idx += 4;
                    this.serverCertRequestReceived = true;
                    idx += len;
                    break;
                }
                case 14: {
                    SSLConnection.debugPrint("processHandshake():  ServerHelloDone");
                    idx += 4;
                    this.serverHelloDoneReceived = true;
                    idx += len;
                    break;
                }
                case 20: {
                    SSLConnection.debugPrint("processHandshake():  Finished");
                    idx += 4;
                    byte[] expected = new byte[36];
                    byte[] md5sum = new byte[16];
                    byte[] sha1sum = new byte[20];
                    byte[] handshakes = this.savedHandshakes.toByteArray();
                    this.md5.init();
                    this.md5.update(handshakes, 0, handshakes.length);
                    this.md5.update(SENDER_SERVER, 0, SENDER_SERVER.length);
                    this.md5.update(this.masterSecret, 0, this.masterSecret.length);
                    this.md5.update(PAD1_MD5, 0, PAD1_MD5.length);
                    this.md5.dump(md5sum, 0);
                    this.md5.init();
                    this.md5.update(this.masterSecret, 0, this.masterSecret.length);
                    this.md5.update(PAD2_MD5, 0, PAD2_MD5.length);
                    this.md5.update(md5sum, 0, md5sum.length);
                    this.md5.dump(expected, 0);
                    this.sha1.init();
                    this.sha1.update(handshakes, 0, handshakes.length);
                    this.sha1.update(SENDER_SERVER, 0, SENDER_SERVER.length);
                    this.sha1.update(this.masterSecret, 0, this.masterSecret.length);
                    this.sha1.update(PAD1_SHA, 0, PAD1_SHA.length);
                    this.sha1.dump(sha1sum, 0);
                    this.sha1.init();
                    this.sha1.update(this.masterSecret, 0, this.masterSecret.length);
                    this.sha1.update(PAD2_SHA, 0, PAD2_SHA.length);
                    this.sha1.update(sha1sum, 0, sha1sum.length);
                    this.sha1.dump(expected, 16);
                    for (int i = 0; i < expected.length; ++i) {
                        if (expected[i] == handshake.content[idx + i]) continue;
                        this.writeAlert((byte)2, (byte)40);
                        this.closeConnection();
                        throw new IOException("Mismatch in finished message.");
                    }
                    SSLConnection.debugPrint("Finished message matched.");
                    this.serverFinishedReceived = true;
                    idx += len;
                    break;
                }
            }
        }
    }

    private void processApplicationData(SSLRecord record) {
        String s = new String(record.content, 0, (int)record.length);
        SSLConnection.debugPrint("App Data: " + s);
    }

    private void closeConnection() throws IOException {
        this.in.close();
        this.out.close();
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            byte[] bytes = s.getBytes();
            this.write(bytes, 0, bytes.length, (byte)23);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.write(b, 0, b.length, (byte)23);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.write(b, off, len, (byte)23);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.write(new byte[]{(byte)b}, 0, 1, (byte)23);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            block11: while (this.bytesRemaining <= 0) {
                try {
                    this.readRecord(this.inputRecord);
                }
                catch (EOFException e) {
                    return -1;
                }
                switch (this.inputRecord.type) {
                    case 20: {
                        this.writeAlert((byte)2, (byte)10);
                        this.closeConnection();
                        throw new IOException("Received unexpected ChangeCipherSpec message.");
                    }
                    case 21: {
                        this.processAlerts(this.inputRecord);
                        continue block11;
                    }
                    case 22: {
                        SSLConnection.debugPrint("Received a handshake in read().. ignoring");
                        continue block11;
                    }
                    case 23: {
                        this.bytesRemaining = this.inputRecord.length;
                        this.currOffset = 0;
                        continue block11;
                    }
                }
                this.writeAlert((byte)2, (byte)10);
                this.closeConnection();
                throw new IOException("unexpected message");
            }
        }
        int readLen = len > this.bytesRemaining ? this.bytesRemaining : len;
        System.arraycopy(this.inputRecord.content, this.currOffset, b, off, readLen);
        this.bytesRemaining -= readLen;
        this.currOffset += readLen;
        return readLen;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        int b;
        Object object = this.readLock;
        synchronized (object) {
            this.read(this.oneReadByte, 0, 1);
            b = this.oneReadByte[0] & 0xFF;
        }
        return b;
    }

    public int available() throws IOException {
        return this.bytesRemaining;
    }

    public void close() throws IOException {
        try {
            this.writeAlert((byte)1, (byte)0);
        }
        catch (IOException e) {
            SSLConnection.debugPrint("Error sending close alert: " + e.getMessage());
            e.printStackTrace();
        }
        this.closeConnection();
    }

    public InputStream getInputStream() {
        return new SSLInputStream(this);
    }

    public OutputStream getOutputStream() {
        return new SSLOutputStream(this);
    }

    public static void main(String[] args) {
        try {
            SSLConnection conn = new SSLConnection("127.0.0.1", 13760);
            String msg = "Yo\n";
            conn.write(msg);
            SSLConnection.debugPrint("sent: " + msg);
            byte[] resp = new byte[256];
            int rc = conn.read(resp);
            SSLConnection.debugPrint("read " + rc + "bytes");
            SSLConnection.debugPrint(new String(resp, 0, rc));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void debugPrint(Object o) {
        if (debug) {
            System.out.println(o);
        }
    }

    static {
        int i;
        SENDER_CLIENT = new byte[]{67, 76, 78, 84};
        SENDER_SERVER = new byte[]{83, 82, 86, 82};
        PAD1_MD5 = new byte[48];
        PAD2_MD5 = new byte[48];
        PAD1_SHA = new byte[40];
        PAD2_SHA = new byte[40];
        debug = false;
        for (i = 0; i < PAD1_MD5.length; ++i) {
            SSLConnection.PAD1_MD5[i] = 54;
        }
        for (i = 0; i < PAD2_MD5.length; ++i) {
            SSLConnection.PAD2_MD5[i] = 92;
        }
        for (i = 0; i < PAD1_SHA.length; ++i) {
            SSLConnection.PAD1_SHA[i] = 54;
        }
        for (i = 0; i < PAD2_SHA.length; ++i) {
            SSLConnection.PAD2_SHA[i] = 92;
        }
        changeCipherSpecBlock = new byte[]{1};
    }

    static class SSLRecord {
        byte type;
        short length;
        byte majorVersion;
        byte minorVersion;
        byte[] content = new byte[16384];

        SSLRecord() {
        }

        public String toString() {
            return "SSLRecord: type=[" + this.type + "]; version=[" + this.majorVersion + "," + this.minorVersion + "]; length=[" + this.length + "].";
        }
    }
}

